﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace WindowsFormsApplication1
{
    partial class FormMain
    {
        // Create a graphics for the picture box.
        Graphics graphicsReadSpeed;

        // The list for the speed reading.
        List<Int16> speedList = new List<Int16>();

        


        private void buttonReadSpeedStartStop_Click(object sender, EventArgs e)
        {
            // If current state is "Stop"...
            if (this.buttonReadSpeedStartStop.Text == "Start")
            {
                // Enable the Timer.
                this.timerReadSpeed.Enabled = true;

                // Change the text to "Stop"
                this.buttonReadSpeedStartStop.Text = "Stop";
            }

            else
            {
                // Disable the Timer.
                this.timerReadSpeed.Enabled = false;

                // Change the text to "Stop"
                this.buttonReadSpeedStartStop.Text = "Start";

                // Change the current speed label to "Current Speed (rpm): N/A".
                this.labelCurrentSpeed.Text = "Current Speed (rpm): N/A";

                // Reset the speed list.
                this.speedList.Clear();
            }

        }



        private void timerReadSpeed_Tick(object sender, EventArgs e)
        {
            // Send the command to read the motor speed.
            Int16 speed = this.bld04aCommand.readMotorSpeed();

            // Update the value in the label.
            this.labelCurrentSpeed.Text = "Current Speed (rpm): " + speed.ToString();



            // Add the speed reading to the list.
            this.speedList.Add((Int16)(speed * (Int16)this.pictureBoxReadSpeed.Height / 4000));

            // Remove the first item in the list if the length > picture box's width.
            if (this.speedList.Count > this.pictureBoxReadSpeed.Width)
            {
                this.speedList.RemoveAt(0);
            }

            // Construct the points array from the speed list.
            Point[] pointsArray = new Point[this.speedList.Count];
            for (int i = 0; i < this.speedList.Count; i++)
            {
                pointsArray[i] = new Point(i, this.pictureBoxReadSpeed.Height - this.speedList.ElementAt(i));
            }


            // Only start drawing when there are > 1 items in the points array.
            if (pointsArray.Length > 1)
            {
                // Clear the picture box.
                this.graphicsReadSpeed.Clear(this.pictureBoxReadSpeed.BackColor);

                // Draw the speed graph.
                this.graphicsReadSpeed.DrawLines(Pens.Red, pointsArray);
            }
        }
    }
}
